function [mk_LKS, mk_GKS, m_T] = mk_Stapa(E, I, A, L, alfa, tipStapa)
% Odredjivanje matrice krutosti i matrice transformacije stapa
% E - modul elasticnosti
% I - aksijalni moment inercije
% A - povrsina poprecnog preseka
% L - duzina stapa
% alfa - ugao izmedju X ose GKS i x ose LKS stapa
% tipStapa = 'k' (prosiriti funkciju i za stapove tipa 'ig', 'gk' i 'p')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mk_LKS=zeros(6,6);
mk_GKS=zeros(6,6);
m_T=zeros(6,6);
if strcmp(tipStapa, 'k')
    mk_LKS=(E*I/L^3)*...
           [A*L^2/I 0 0 -A*L^2/I 0 0;
            0 12 6*L 0 -12 6*L;
            0 6*L 4*L^2 0 -6*L 2*L^2;
            -A*L^2/I 0 0 A*L^2/I 0 0;
            0 -12 -6*L 0 12 -6*L;
            0 6*L 2*L^2 0 -6*L 4*L^2];
    m_T=[cos(alfa) sin(alfa) 0 0 0 0;
         -sin(alfa) cos(alfa) 0 0 0 0;
         0 0 1 0 0 0;
         0 0 0 cos(alfa) sin(alfa) 0;
         0 0 0 -sin(alfa) cos(alfa) 0;
         0 0 0 0 0 1];
    mk_GKS=transpose(m_T)*mk_LKS*m_T;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%